// MoviePlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MoviePlayer.h"
#include "MoviePlayerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMoviePlayerDlg dialog

CMoviePlayerDlg::CMoviePlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMoviePlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMoviePlayerDlg)
	m_iPlayBackRate = 1.0;
	m_iTotalDur = 0.0;
	m_iVideoWidth = 0;
	m_iVideoHeight = 0;
	m_bLoop = TRUE;
	m_bAspectRatio = TRUE;
	m_iOptDrawMode = 0;
	m_strText = _T("Movie Player Pro ActiveX");
	m_iCurPos = 0.0;
	m_strText2 = _T("www.viscomsoft.com");
	m_iMPEG1Audio = 0;
	m_iClearType = 0;
	m_iFrameRate = 0.0;
	m_iVideoBitrate = 0;
	m_iAudioBitrate = 0;
	m_iAudioChannel = 0;
	m_strContainer = _T("");
	m_strVideoFormat = _T("");
	m_strAudioFormat = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_clrTranColor=RGB(0,0,0);
	m_clrBgColor=RGB(0,0,0);
	m_clrFontColor=RGB(255,255,255);
	m_iAlign=0;

}

void CMoviePlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMoviePlayerDlg)
	DDX_Control(pDX, IDC_CBOMOUSEBUTTON, m_CboMouseButton);
	DDX_Control(pDX, IDC_CBOKEY, m_CboKey);
	DDX_Control(pDX, IDC_BTNPAUSE, m_BtnPause);
	DDX_Control(pDX, IDC_BTNSTOP, m_BtnStop);
	DDX_Control(pDX, IDC_BTNPLAY, m_BtnPlay);
	DDX_Control(pDX, IDC_BUTTON3, m_BtnTempoDefault);
	DDX_Control(pDX, IDC_BUTTON2, m_BtnPitchDefault);
	DDX_Control(pDX, IDC_CHECK1, m_ChkUsePitch);
	DDX_Control(pDX, IDC_SLIDER4, m_SliderTempoDecrease);
	DDX_Control(pDX, IDC_SLIDER3, m_SliderTempoIncrease);
	DDX_Control(pDX, IDC_SLIDER2, m_SliderPitch);
	DDX_Control(pDX, IDC_SliderImageTextYPos, m_SliderImageTextY);
	DDX_Control(pDX, IDC_SliderImageTextXPos, m_SliderImageTextX);
	DDX_Control(pDX, IDC_SliderScroll, m_SliderScrollSpeed);
	DDX_Control(pDX, IDC_SliderAlpha, m_SliderAlpha);
	DDX_Control(pDX, IDC_SliderYPos, m_SliderYPos);
	DDX_Control(pDX, IDC_SliderXPos, m_SliderXPos);
	DDX_Control(pDX, IDC_CBOFONTNAME, m_CboFontName);
	DDX_Control(pDX, IDC_CBOFONTSIZE, m_CboFontSize);
	DDX_Control(pDX, IDC_CBOSTYLE, m_CboStyle);
	DDX_Control(pDX, IDC_SLIDERSOUND, m_SliderSound);
	DDX_Control(pDX, IDC_SLIDER1, m_Slider);
	DDX_Control(pDX, IDC_MOVIEPLAYERCTRL1, m_MoviePlayer);
	DDX_Text(pDX, IDC_EDITPLAYBACKRATE, m_iPlayBackRate);
	DDX_Text(pDX, IDC_EDITTOTDUR, m_iTotalDur);
	DDX_Text(pDX, IDC_EDITVIDEOWIDTH, m_iVideoWidth);
	DDX_Text(pDX, IDC_EDITVIDEOHEIGHT, m_iVideoHeight);
	DDX_Check(pDX, IDC_CHECKLOOP, m_bLoop);
	DDX_Check(pDX, IDC_CHECKASPECTRATIO, m_bAspectRatio);
	DDX_Radio(pDX, IDC_RADIODRAWMODE, m_iOptDrawMode);
	DDX_Text(pDX, IDC_EDITTEXT, m_strText);
	DDX_Text(pDX, IDC_EDITCURPOS, m_iCurPos);
	DDX_Text(pDX, IDC_EDITTEXT2, m_strText2);
	DDX_Radio(pDX, IDC_RADIO1, m_iMPEG1Audio);
	DDX_Radio(pDX, IDC_RADIO6, m_iClearType);
	DDX_Text(pDX, IDC_EDITFRAMERATE, m_iFrameRate);
	DDX_Text(pDX, IDC_EDITVIDEOBITRATE, m_iVideoBitrate);
	DDX_Text(pDX, IDC_EDITAUDIOBITRATE, m_iAudioBitrate);
	DDX_Text(pDX, IDC_EDITAUDIOCHANNEL, m_iAudioChannel);
	DDX_Text(pDX, IDC_EDITCONTAINER, m_strContainer);
	DDX_Text(pDX, IDC_EDITVIDEOFORMAT, m_strVideoFormat);
	DDX_Text(pDX, IDC_EDITAUDIOFORMAT, m_strAudioFormat);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMoviePlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CMoviePlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BTNPLAY, OnBtnplay)
	ON_BN_CLICKED(IDC_BTNSTOP, OnBtnstop)
	ON_BN_CLICKED(IDC_BTNPAUSE, OnBtnpause)
	ON_BN_CLICKED(IDC_BTNSNAPSHOT, OnBtnsnapshot)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BTNRESIZE1, OnBtnresize1)
	ON_BN_CLICKED(IDC_CHECKASPECTRATIO, OnCheckaspectratio)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_BTNRESIZE2, OnBtnresize2)
	ON_BN_CLICKED(IDC_BTNFONTCOLOR, OnBtnfontcolor)
	ON_BN_CLICKED(IDC_BTNBGCOLOR, OnBtnbgcolor)
	ON_BN_CLICKED(IDC_BTNTRANCOLOR, OnBtntrancolor)
	ON_BN_CLICKED(IDC_RADIODRAWMODE, OnRadiodrawmode)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_CHKFONTBOLD, OnChkfontbold)
	ON_BN_CLICKED(IDC_CHKFONTITALIC, OnChkfontitalic)
	ON_BN_CLICKED(IDC_CHKFONTUNDERLINE, OnChkfontunderline)
	ON_BN_CLICKED(IDC_BTNDRAWTEXT, OnBtndrawtext)
	ON_CBN_SELCHANGE(IDC_CBOSTYLE, OnSelchangeCbostyle)
	ON_CBN_SELCHANGE(IDC_CBOFONTSIZE, OnSelchangeCbofontsize)
	ON_CBN_SELCHANGE(IDC_CBOFONTNAME, OnSelchangeCbofontname)
	ON_BN_CLICKED(IDC_RADIOALIGNLEFT, OnRadioalignleft)
	ON_BN_CLICKED(IDC_RADIOALIGNCENTER, OnRadioaligncenter)
	ON_BN_CLICKED(IDC_RADIOALIGNRIGHT, OnRadioalignright)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_BTNFULLSCREEN, OnBtnfullscreen)
	ON_CBN_SELCHANGE(IDC_CBOMOUSEBUTTON, OnSelchangeCbomousebutton)
	ON_CBN_SELCHANGE(IDC_CBOKEY, OnSelchangeCbokey)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMoviePlayerDlg message handlers

BOOL CMoviePlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_SliderSound.SetRange(0,10000);
	m_SliderSound.SetPos(10000);

	m_SliderImageTextX.SetRange(0,300);
	m_SliderImageTextY.SetRange(0,300);
	m_SliderImageTextY.SetPos(100);


	m_CboStyle.AddString("No Scroll");
	m_CboStyle.AddString("Scroll Left");
	m_CboStyle.AddString("Scroll Right");
	m_CboStyle.SetCurSel(0);

	
	((CButton*)GetDlgItem(IDC_RADIOALIGNLEFT))->SetCheck(1);

	int iFontSize;

	CString strFontSize;

	for(int i=8;i<60;i++)
	{
		strFontSize.Format("%d",i);
		m_CboFontSize.AddString(strFontSize);
	}
	m_CboFontSize.SetCurSel(4);
	

	m_CboFontName.AddString("Arial");
	m_CboFontName.AddString("Impact");
	m_CboFontName.AddString("Times New Roman");
	m_CboFontName.SetCurSel(0);



	m_SliderXPos.SetRange(0,100);
	m_SliderXPos.SetPos(0);

	m_SliderYPos.SetRange(0,100);
	m_SliderYPos.SetPos(0);


	m_SliderAlpha.SetRange(0,100);
	m_SliderAlpha.SetPos(100);

	m_SliderScrollSpeed.SetRange(0,500);
	m_SliderScrollSpeed.SetPos(125);

	m_MoviePlayer.RegisterMsg();

	m_SliderPitch.SetRange(0,24);
	m_SliderPitch.SetPos(12);

	m_SliderTempoIncrease.SetRange(0,100);
	m_SliderTempoDecrease.SetRange(0,50);

	m_MoviePlayer.SetUsePitchTempo(TRUE);

	this->m_CboKey.AddString("Esc Key");
	this->m_CboKey.AddString("Enter Key");
	this->m_CboKey.AddString("SpaceBar Key");
	this->m_CboKey.AddString("Q Key");
	this->m_CboKey.SetCurSel(0);

	m_CboMouseButton.AddString("Left ButtonDown");
	m_CboMouseButton.AddString("Left ButtonDblClk");
	m_CboMouseButton.AddString("Right ButtonDown");
	m_CboMouseButton.AddString("Right ButtonDblClk");
	m_CboMouseButton.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMoviePlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMoviePlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMoviePlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMoviePlayerDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	char szFilter[]="All Files (*.*)|*.*|Flash file (*.swf) | *.swf|AVCHD, TS(*.m2ts,ts)|*.m2ts;*.ts;*.mts*.m2t|vob (*.vob) | *.vob|F4V (*.f4v)|*.f4v|MKV (*.mkv) | *.mkv|DIVX (*.divx) | *.divx|flv (*.flv) | *.flv|mpg (*.mpg) | *.mpg;*.mpeg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf|mov (*.mov) | *.mov|mp4 (*.mp4) | *.mp4 |3gp (*.3gp) | *.3gp|JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif ||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
		if(this->m_ChkUsePitch.GetCheck()==1)
			m_MoviePlayer.SetUsePitchTempo(TRUE);
		else
			m_MoviePlayer.SetUsePitchTempo(FALSE);
	
		m_MoviePlayer.SetUseVideoColor(FALSE);

		m_MoviePlayer.SetFileName(dlg.GetPathName());
		m_Slider.SetRange(0,m_MoviePlayer.GetDuration());
		m_iVideoWidth= m_MoviePlayer.GetVideoWidth();
		m_iVideoHeight= m_MoviePlayer.GetVideoHeight();
		m_iTotalDur= m_MoviePlayer.GetDuration();

		m_iFrameRate = m_MoviePlayer.GetFrameRate();

		
		m_iVideoBitrate = m_MoviePlayer.GetVideoBitrate();
		m_iAudioBitrate = m_MoviePlayer.GetAudioBitrate();
		m_iAudioChannel= m_MoviePlayer.GetAudioChannels();
		m_strAudioFormat= m_MoviePlayer.GetAudioStreamFormat();
		m_strVideoFormat= m_MoviePlayer.GetVideoStreamFormat();
		m_strContainer = m_MoviePlayer.GetMediaContainerName();
		UpdateData(FALSE);
		
		m_ChkUsePitch.EnableWindow(FALSE);

		m_BtnPlay.EnableWindow(TRUE);
		m_BtnStop.EnableWindow(FALSE);
		m_BtnPause.EnableWindow(FALSE);

	}
	
	
}

void CMoviePlayerDlg::OnBtnplay() 
{
	// TODO: Add your control notification handler code here

	m_MoviePlayer.SetSoundVolume(0);
	m_MoviePlayer.Play();
	DrawMyText();

	m_BtnPlay.EnableWindow(FALSE);
	m_BtnStop.EnableWindow(TRUE);
	m_BtnPause.EnableWindow(TRUE);
}

void CMoviePlayerDlg::OnBtnstop() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.Stop();
	m_BtnPlay.EnableWindow(FALSE);
	m_BtnStop.EnableWindow(FALSE);
	m_BtnPause.EnableWindow(FALSE);
	m_ChkUsePitch.EnableWindow(TRUE);

}

void CMoviePlayerDlg::OnBtnpause() 
{
	// TODO: Add your control notification handler code here
	
		m_MoviePlayer.Pause();
	m_BtnPlay.EnableWindow(TRUE);
	m_BtnStop.EnableWindow(FALSE);
	m_BtnPause.EnableWindow(FALSE);

}

void CMoviePlayerDlg::OnBtnsnapshot() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.SnapShot("c:\\test.bmp");
	AfxMessageBox("save c:\\test.bmp completed");
}

void CMoviePlayerDlg::OnButton4() 
{
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);
	
	m_MoviePlayer.SetPlaybackRate(m_iPlayBackRate);

}

BEGIN_EVENTSINK_MAP(CMoviePlayerDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CMoviePlayerDlg)
	ON_EVENT(CMoviePlayerDlg, IDC_MOVIEPLAYERCTRL1, 1 /* OnCompleted */, OnOnCompletedMovieplayerctrl1, VTS_NONE)
	ON_EVENT(CMoviePlayerDlg, IDC_MOVIEPLAYERCTRL1, 2 /* OnPlaying */, OnOnPlayingMovieplayerctrl1, VTS_R8 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CMoviePlayerDlg::OnBtnresize1() 
{
	// TODO: Add your control notification handler code here

	m_MoviePlayer.ResizeControl(100,100);

}


void CMoviePlayerDlg::OnCheckaspectratio() 
{
	// TODO: Add your control notification handler code here
	if(((CButton*)GetDlgItem(IDC_CHECKASPECTRATIO))->GetCheck()==1)
		m_MoviePlayer.SetAspectRatio(TRUE);
	else
		m_MoviePlayer.SetAspectRatio(FALSE);

	
}
void CMoviePlayerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	if(pScrollBar->GetDlgCtrlID()==IDC_SLIDERSOUND)
	{
		m_MoviePlayer.SetSoundVolume(m_SliderSound.GetPos()-10000);
	}
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderXPos)
		DrawMyText();
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderYPos)
		DrawMyText();
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderAlpha)
		DrawMyText();
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderScroll)
		DrawMyText();
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderImageTextXPos)
		DrawMyText();
	else if(pScrollBar->GetDlgCtrlID()==IDC_SliderImageTextYPos)
		DrawMyText();

	else if(pScrollBar->GetDlgCtrlID()==IDC_SLIDER2)
	{
		m_MoviePlayer.ChangePitch(m_SliderPitch.GetPos()-12);
	}
	else if(pScrollBar->GetDlgCtrlID()==IDC_SLIDER3)
	{
		m_MoviePlayer.ChangeTempo(m_SliderTempoIncrease.GetPos());
	}
	else if(pScrollBar->GetDlgCtrlID()==IDC_SLIDER4)
	{
		m_MoviePlayer.ChangeTempo(m_SliderTempoDecrease.GetPos()*-1);
	}





	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CMoviePlayerDlg::OnBtnresize2() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.ResizeControl(200,200);
	
}

void CMoviePlayerDlg::DrawMyText()
{
	int iStyle,iSpeed,iFontSize;
	float iAlpha;
	float iXPos,iYPos;
	
	iXPos = m_SliderXPos.GetPos();

	if(iXPos !=0)
		iXPos=iXPos/100;


	iYPos = m_SliderYPos.GetPos();

	if(iYPos !=0)
		iYPos=iYPos/100;

	iStyle =m_CboStyle.GetCurSel();

	iAlpha =m_SliderAlpha.GetPos();

	if(iAlpha !=0)
		iAlpha=iAlpha/100;

	
	iSpeed =m_SliderScrollSpeed.GetPos(); 


	int iSel=m_CboFontName.GetCurSel();

	CString strFontName,strFontSize;
	m_CboFontName.GetLBText(iSel,strFontName);

	iSel=m_CboFontSize.GetCurSel();
	m_CboFontSize.GetLBText(iSel,strFontSize);
	iFontSize=atoi(strFontSize);

	CString strText;
	((CEdit*)GetDlgItem(IDC_EDITTEXT))->GetWindowText(strText);
	
	CString strText2;
	((CEdit*)GetDlgItem(IDC_EDITTEXT2))->GetWindowText(strText2);
	

	CString strImagePath=((CMoviePlayerApp*)AfxGetApp())->m_strAppPath +"\\image.bmp";
	
//	AfxMessageBox(strImagePath);

	
	BOOL bFontBold=((CButton*)GetDlgItem(IDC_CHKFONTBOLD))->GetCheck();
	BOOL bFontItalic=((CButton*)GetDlgItem(IDC_CHKFONTITALIC))->GetCheck();
	BOOL bFontUnderline=((CButton*)GetDlgItem(IDC_CHKFONTUNDERLINE))->GetCheck();



	UpdateData(TRUE);

	if(m_iOptDrawMode==0)
	{
		m_MoviePlayer.DrawImage(iXPos,iYPos,iStyle,strImagePath,m_clrTranColor, iAlpha, iSpeed);
	}
	else if(m_iOptDrawMode==1)
	{
		m_MoviePlayer.ShowBitmapOnDrawText("",m_SliderImageTextX.GetPos(),m_SliderImageTextY.GetPos());
		m_MoviePlayer.DrawText(iXPos,iYPos,iStyle,strText + CString("\r\n") + strText2 ,iFontSize,strFontName,bFontBold,bFontItalic,bFontUnderline,m_clrFontColor,m_clrBgColor,m_clrTranColor,iAlpha, iSpeed,m_iAlign);
	}
	else
	{
		m_MoviePlayer.ShowBitmapOnDrawText(strImagePath,m_SliderImageTextX.GetPos(),m_SliderImageTextY.GetPos());
		m_MoviePlayer.DrawText(iXPos,iYPos,iStyle,strText + CString("\r\n") + strText2 ,iFontSize,strFontName,bFontBold,bFontItalic,bFontUnderline,m_clrFontColor,m_clrBgColor,m_clrTranColor,iAlpha, iSpeed,m_iAlign);
	}


}

void CMoviePlayerDlg::OnBtnfontcolor() 
{
	// TODO: Add your control notification handler code here

	CColorDialog dlg;
	if(dlg.DoModal()==IDOK)
	{
		m_clrFontColor=dlg.GetColor();
		DrawMyText();
	}

}

void CMoviePlayerDlg::OnBtnbgcolor() 
{
	// TODO: Add your control notification handler code here
	CColorDialog dlg;
	if(dlg.DoModal()==IDOK)
	{
		m_clrBgColor=dlg.GetColor();
		DrawMyText();
	}
	
}

void CMoviePlayerDlg::OnBtntrancolor() 
{
	// TODO: Add your control notification handler code here

	
}

void CMoviePlayerDlg::OnRadiodrawmode() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
}

void CMoviePlayerDlg::OnRadio2() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
	
}

void CMoviePlayerDlg::OnChkfontbold() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
}

void CMoviePlayerDlg::OnChkfontitalic() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
}

void CMoviePlayerDlg::OnChkfontunderline() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
}

void CMoviePlayerDlg::OnBtndrawtext() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();		
}

void CMoviePlayerDlg::OnSelchangeCbostyle() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();		
}

void CMoviePlayerDlg::OnSelchangeCbofontsize() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();
}

void CMoviePlayerDlg::OnSelchangeCbofontname() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();
}


void CMoviePlayerDlg::OnOnCompletedMovieplayerctrl1() 
{
	// TODO: Add your control notification handler code here
	if(((CButton*)GetDlgItem(IDC_CHECKLOOP))->GetCheck()==1)
		m_MoviePlayer.Play();
	else
	{
	m_BtnPlay.EnableWindow(TRUE);
	m_BtnStop.EnableWindow(FALSE);
	m_BtnPause.EnableWindow(FALSE);
	m_ChkUsePitch.EnableWindow(TRUE);
	}

}

void CMoviePlayerDlg::OnOnPlayingMovieplayerctrl1(double iCurrent, LPCTSTR strTime) 
{
	// TODO: Add your control notification handler code here
		m_Slider.SetPos(iCurrent);	
	CString str;
	str.Format("%f",iCurrent);

	GetDlgItem(IDC_EDITCURPOS)->SetWindowText(str);	
}


void CMoviePlayerDlg::OnRadioalignleft() 
{
	// TODO: Add your control notification handler code here
	m_iAlign=0;
	DrawMyText();		
}

void CMoviePlayerDlg::OnRadioaligncenter() 
{
	// TODO: Add your control notification handler code here
	m_iAlign=1;	
	DrawMyText();		
}

void CMoviePlayerDlg::OnRadioalignright() 
{
	// TODO: Add your control notification handler code here
	m_iAlign=2;
	DrawMyText();		
}

void CMoviePlayerDlg::OnRadio3() 
{
	// TODO: Add your control notification handler code here
	DrawMyText();	
	
}

void CMoviePlayerDlg::OnRadio1() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.SetMPEG1AudioChannel(0);

}

void CMoviePlayerDlg::OnRadio4() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.SetMPEG1AudioChannel(1);

}

void CMoviePlayerDlg::OnRadio5() 
{
	// TODO: Add your control notification handler code here
	m_MoviePlayer.SetMPEG1AudioChannel(2);

}

void CMoviePlayerDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
		m_MoviePlayer.UnRegisterMsg();

	CDialog::OnClose();
}

void CMoviePlayerDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
		m_SliderPitch.SetPos(12);
	m_MoviePlayer.ChangePitch(m_SliderPitch.GetPos()-12);
}

void CMoviePlayerDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
		m_SliderTempoIncrease.SetPos(0);
		m_SliderTempoDecrease.SetPos(0);
	m_MoviePlayer.ChangeTempo(0);
}

void CMoviePlayerDlg::OnCheck1() 
{
	// TODO: Add your control notification handler code here
	if( m_ChkUsePitch.GetCheck()==1)
	{
		m_ChkUsePitch.EnableWindow(TRUE);
		m_SliderPitch.EnableWindow(TRUE);
		m_SliderTempoIncrease.EnableWindow(TRUE);
		m_SliderTempoDecrease.EnableWindow(TRUE);
		m_BtnPitchDefault.EnableWindow(TRUE);
		m_BtnTempoDefault.EnableWindow(TRUE);

	}
	else
	{

		m_ChkUsePitch.EnableWindow(FALSE);
		m_SliderPitch.EnableWindow(FALSE);
		m_SliderTempoIncrease.EnableWindow(FALSE);
		m_SliderTempoDecrease.EnableWindow(FALSE);
		m_BtnPitchDefault.EnableWindow(FALSE);
		m_BtnTempoDefault.EnableWindow(FALSE);

	}
}

void CMoviePlayerDlg::OnBtnfullscreen() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	if(m_iClearType==0)
		m_MoviePlayer.SetClearFullScreenType(0);
	else
	{
		//AfxMessageBox("a");
		m_MoviePlayer.SetClearFullScreenType(1);

		int iIndex =0;
		
		iIndex=m_CboMouseButton.GetCurSel();

		if(iIndex!=-1)
			m_MoviePlayer.SetClearFullScreenMouseButton(iIndex);
		else
			m_MoviePlayer.SetClearFullScreenMouseButton(0);
	
		//m_MoviePlayer.SetClearFullScreenMouseButton(m_CboMouseButton.GetCurSel());
	}

	m_MoviePlayer.ShowFullScreen(true);
}

BOOL CMoviePlayerDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	UpdateData(TRUE);

	if(m_MoviePlayer.IsFullScreen())
	{
	if(m_iClearType==0)
	{
		if(pMsg->message == WM_KEYDOWN)
		{

			if(pMsg->wParam == VK_ESCAPE && m_CboKey.GetCurSel()==0)
			{
				m_MoviePlayer.ShowFullScreen(FALSE);
				return TRUE;
			}
			else if(pMsg->wParam ==  VK_RETURN && m_CboKey.GetCurSel()==1)
			{
				m_MoviePlayer.ShowFullScreen(FALSE);
				return TRUE;
			}
			else if(pMsg->wParam ==  VK_SPACE && m_CboKey.GetCurSel()==2)
			{
				m_MoviePlayer.ShowFullScreen(FALSE);
				return TRUE;
			}
			else if(pMsg->wParam == 81 && m_CboKey.GetCurSel()==3)
			{
				m_MoviePlayer.ShowFullScreen(FALSE);
				return TRUE;
			}
		
			else
				pMsg->wParam=NULL ;	

		}
		

	}
	else
	{
			if(pMsg->message == WM_KEYDOWN)
			{
				   pMsg->wParam=NULL ;	
			}

	}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CMoviePlayerDlg::OnSelchangeCbomousebutton() 
{
	// TODO: Add your control notification handler code here


}

void CMoviePlayerDlg::OnSelchangeCbokey() 
{
	// TODO: Add your control notification handler code here


}

void CMoviePlayerDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default


	CDialog::OnLButtonDown(nFlags, point);
}
